PROCEDURE CollectLabelLegends;
{$DEBUG}

TYPE
	LLArrayElement = STRUCTURE
		ResIndex	:INTEGER;
		LLHdl		:HANDLE;
		LLNm		:STRING;
	END;
	
VAR
	Index					:INTEGER;
	Index2				:INTEGER;
	RecListID			:LONGINT;
	RecResourceList	:LONGINT;
	LLName				:STRING;
	LLArray				:ARRAY[1..1000] OF LLArrayElement;
	LLHandle				:HANDLE;
	ResType				:INTEGER;
	NumLLs				:INTEGER;
	NumRes				:INTEGER;
	NameHolder			:STRING;
	
{===================================================================}

	FUNCTION ImportResCallback(VAR resourceName:DYNARRAY OF CHAR) : INTEGER;
		BEGIN
			resourceName := Concat( resourceName , '-1' );
			Message('resourceName = ', resourceName);  	
			ImportResCallback := 0;
		END;
	
{===================================================================}

BEGIN
	NumLLs := 0;
	RecResourceList := BuildResourceList(16, -2, '', NumRes);
	BeginContext;
		FOR Index := 1 TO NumRes DO
			BEGIN
				LLHandle := ImportResToCurFileN( RecResourceList , Index, ImportResCallback );
				LLName := GetName(LLHandle);
				ResType := GetTypeN(LLHandle);
				IF (ResType = 16) THEN
					BEGIN
						FOR Index2 := 1 TO NumRecords(LLHandle) DO
							BEGIN
								NameHolder := GetName(GetRecord(LLHandle, Index2));
								IF NameHolder = '__NNA_SL_Label_Record' THEN
								(*IF NameHolder = 'Legends Rec' THEN*)
									BEGIN
										NumLLs := NumLLs + 1;
										LLArray[NumLLs].ResIndex := Index;
										LLArray[NumLLs].LLNm := GetActualNameFromResourceList(RecResourceList, Index);
									END;
							END; {FOR Index2 := 1 TO NumRecords(LLHandle) }
					END; {IF ResType = 16 | ResType = 15 }
				DelObject(LLHandle);
			END; {FOR Index := 1 TO NumRes}
	EndContext(0);
	ClrMessage;
END;
RUN(CollectLabelLegends);